unit Question2_U;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ADODB, DB, Math, Jpeg, StdCtrls, Grids, DBGrids, ComCtrls, CheckLst,
  ExtCtrls, Spin;

type
  TfrmQuestion2 = class(TForm)
    dbgTable: TDBGrid;
    btn212: TButton;
    pctHealth: TPageControl;
    tabQ21: TTabSheet;
    btnRestoreDB: TButton;
    tabQ22: TTabSheet;
    radSort211: TRadioGroup;
    btn213: TButton;
    redOutput: TRichEdit;
    dbgData: TDBGrid;
    btn221: TButton;
    btn222: TButton;
    btn223: TButton;
    edtSearch: TEdit;
    edtName: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    chkSmoke: TCheckBox;
    edtEmail: TEdit;
    sedWeight: TSpinEdit;
    sedHeight: TSpinEdit;
    edtDate: TEdit;
    cmbGender: TComboBox;
    btn214: TButton;
    procedure FormActivate(Sender: TObject);
    procedure btnRestoreDBClick(Sender: TObject);
    procedure connectDB;
    procedure btn212Click(Sender: TObject);
    procedure radSort211Click(Sender: TObject);
    procedure btn223Click(Sender: TObject);
    procedure btn221Click(Sender: TObject);
    procedure btn213Click(Sender: TObject);
    procedure btn214Click(Sender: TObject);
    procedure btn222Click(Sender: TObject);

  private
    { Private declarations }
  var
    conDB: TADOConnection;
    tblMember: TADOtable;
    qry: TADOQuery;
    dsrTbl: TDataSource;
    dsrSQL: TDataSource;
    SQL: String;

  public
    { Public declarations }
  end;

var
  frmQuestion2: TfrmQuestion2;

implementation

{$R *.dfm}

procedure TfrmQuestion2.radSort211Click(Sender: TObject);
  begin // Question 2.1.1
    if radSort211.ItemIndex = 0 then
      begin
        tblMember.Sort := 'JoinDate DESC';
      end
    else if radSort211.ItemIndex = 1 then
      begin
        tblMember.Sort := 'MemberName ASC';
      end;

  end;

procedure TfrmQuestion2.btn212Click(Sender: TObject);
  var
    sSearch: String;
    bFound: Boolean;
  begin // Question 2.1.2
    bFound := False;
    sSearch := edtSearch.Text;

    tblMember.First;
    while (not tblMember.Eof) AND (NOT bFound) do
      begin
        if tblMember['AccNumber'] = sSearch then
          begin
            bFound := True;
            ShowMessage(tblMember['MemberName'] + ' joined on ' + DateToStr
                (tblMember['JoinDate']));
          end;
        tblMember.Next;
      end;

    if NOT bFound then
      ShowMessage('Member no ' + sSearch + ' cannot be found');

  end;

procedure TfrmQuestion2.btn213Click(Sender: TObject);
  var
    rBMI: Real;
    sStatus: String;
  begin // Question 2.1.3
    redOutput.Paragraph.TabCount := 2;
    redOutput.Paragraph.Tab[0] := 140;
    redOutput.Paragraph.Tab[1] := 190;
    redOutput.Lines.Add('Member' + #9 + 'BMI' + #9 + 'Status');
    redOutput.Lines.Add('---------------------------------------------');

    tblMember.First;
    while not tblMember.Eof do
      begin
        rBMI := tblMember['Weight'] /
          (tblMember['Height'] / 100 * tblMember['Height'] / 100);
        if rBMI < 18.5 then
          sStatus := 'Underweight'
        else if (rBMI >= 18.5) AND (rBMI <= 24.9) then
          sStatus := 'Normal'
        else if (rBMI >= 25) AND (rBMI <= 29.9) then
          sStatus := 'Overweight'
        else
          begin
            sStatus := 'Obese'
          end;

        redOutput.Lines.Add(tblMember['MemberName'] + #9 + FloatToStrF(rBMI,
            ffFixed, 8, 1) + #9 + sStatus);
        tblMember.Next;
      end;

  end;

procedure TfrmQuestion2.btn214Click(Sender: TObject);
  var
    iTotalMembers, iMaleSmokers, iMale: Integer;
    rAverage: Real;
  begin // Question 2.1.4
    redOutput.Clear;
    iTotalMembers := 0;
    iMaleSmokers := 0;
    iMale := 0;
    rAverage := 0;

    iTotalMembers := tblMember.RecordCount;

    tblMember.First;
    while (not tblMember.Eof) do
      begin
        if tblMember['Gender'] = 'Male' then
          begin
            Inc(iMale);
            if tblMember['Smoke'] = True then
              begin
                Inc(iMaleSmokers);
              end;
          end;
        tblMember.Next;
      end;

    rAverage := iMaleSmokers / iMale * 100;
    redOutput.Lines.Add('Male Smokers: ' + #9 + IntToStr(iMaleSmokers)
        + ' out of ' + IntToStr(iMale) + ' = ' + FloatToStrF(rAverage,
        ffFixed, 8, 2) + '%');
    redOutput.Lines.Add('Total Members: ' + #9 + IntToStr(iTotalMembers));
  end;

procedure TfrmQuestion2.btn221Click(Sender: TObject);
  var
    bFound: Boolean;
  begin // Question 2.2.1
    bFound := False;
    tblMember.First;
    while (NOT tblMember.Eof) AND (NOT bFound) do
      begin
        if tblMember['AccNumber'] = 'PraM786' then
          begin
            bFound := True;
            tblMember.Edit;
            tblMember['Email'] := 'mpragnel@studpress.com';
            tblMember.Post;
          end;
        tblMember.Next;
      end;

    if Not bFound then
      ShowMessage('Record not found!');
  end;

procedure TfrmQuestion2.btn222Click(Sender: TObject);
  var
  sCurrentName: String;
  begin // Question 2.2.2
    sCurrentName := tblMember['MemberName'];
    tblMember.Edit;
    tblMember.Delete;
    ShowMessage('The record of ' + sCurrentName + ' has been deleted');
  end;

procedure TfrmQuestion2.btn223Click(Sender: TObject);
  var
    sFullName, sEmail, sDate, sAccountNumber, sGender: string;
    iHeight, iWeight, iRandom, iPosSpace: Integer;
    bSmoke: Boolean;
  begin
    // Question 2.2.3
    sFullName := edtName.Text;
    sEmail := edtEmail.Text;
    sDate := edtDate.Text;
    iHeight := sedHeight.Value;
    iWeight := sedWeight.Value;

    sGender := cmbGender.Text;

    iRandom := Random(900) + 100;
    iPosSpace := Pos(' ', sFullName);
    sAccountNumber := Copy(sFullName, 1, 3) + sFullName[iPosSpace + 1] + IntToStr(iRandom);

    if chkSmoke.Checked then
    bSmoke := True
    else
    begin
      bSmoke := False;
    end;

    tblMember.Last;
    tblMember.Insert;
    tblMember['AccNumber'] := sAccountNumber;
    tblMember['MemberName'] := sFullName;
    tblMember['Gender'] := sGender;
    tblMember['Email'] := sEmail;
    tblMember['JoinDate'] := sDate;
    tblMember['Height'] := iHeight;
    tblMember['Weight'] := iWeight;
    tblMember['Smoke'] := bSmoke;
    tblMember.Post;
  end;

procedure TfrmQuestion2.btnRestoreDBClick(Sender: TObject);
  var // Do not change/delete this code!
    bFlag: Boolean;
  begin
    conDB.Connected := False;
    tblMember.Free();

    DeleteFile('Health.mdb');
    CopyFile('HealthBackup.mdb', 'Health.mdb', bFlag);

    connectDB;

    MessageDlg('Database Restored! ', mtInformation, [mbOK], 0);
  end;

procedure TfrmQuestion2.connectDB;
  var // Do not change/delete this code!
    sDBName: String;
  begin
    conDB := TADOConnection.Create(Self);

    sDBName := 'Health';

    conDB.ConnectionString :=
      'Provider=Microsoft.Jet.OLEDB.4.0;Data Source=' + sDBName + '.mdb;' +
      'Mode=ReadWrite;Persist Security Info=False';

    conDB.LoginPrompt := False;
    conDB.Connected := True;

    tblMember := TADOtable.Create(Self);
    tblMember.Connection := conDB;
    // replace TABLE Name
    tblMember.TableName := 'Members';
    tblMember.Active := True;

    qry := TADOQuery.Create(Self);
    qry.Connection := conDB;

    dsrTbl := TDataSource.Create(Self);
    dsrTbl.DataSet := tblMember;

    dbgTable.DataSource := dsrTbl;
    dbgData.DataSource := dsrTbl;
    dsrSQL := TDataSource.Create(Self);
    dsrSQL.DataSet := qry;

  end;

Procedure TfrmQuestion2.FormActivate(Sender: TObject);
  begin
    connectDB;
  end;

end.
